/*
 * Decompiled with CFR 0.152.
 */
package org.raydelto.redirector.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.raydelto.redirector.net.PortListener;

public class PortRedirector
extends Thread {
    private int localPort;
    private int redirectPort;
    private ServerSocket server;
    private Socket client;
    private Socket redirector;
    private PortListener hostListener;
    private PortListener redirectorListener;
    private boolean disabled = false;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        try {
            this.server.close();
        }
        catch (IOException e) {
            System.out.println("Message while stop the redirector:" + e.getMessage());
        }
    }

    public PortRedirector(int localPort, int redirectPort) {
        this.localPort = localPort;
        this.redirectPort = redirectPort;
    }

    @Override
    public void run() {
        System.out.println("Starting the redirection from " + this.localPort + "  to the port: " + this.redirectPort);
        try {
            this.server = new ServerSocket(this.redirectPort);
        }
        catch (IOException e) {
            System.err.println("Could not start local server at port " + this.redirectPort);
            e.printStackTrace();
            System.exit(0);
        }
        while (!this.disabled) {
            try {
                this.client = this.server.accept();
                if (this.client == null) continue;
                System.out.println("Connection received");
                try {
                    System.out.println("Connecting to localhost at port " + this.localPort);
                    this.redirector = new Socket("localhost", this.localPort);
                }
                catch (IOException e) {
                    System.err.println("Could not connect to the redirected port, exiting the program");
                    e.printStackTrace();
                    System.exit(0);
                }
                this.hostListener = new PortListener(this.client.getInputStream(), this.redirector.getOutputStream(), this.client);
                this.redirectorListener = new PortListener(this.redirector.getInputStream(), this.client.getOutputStream(), this.redirector);
                this.hostListener.setFriendListener(this.redirectorListener);
                this.redirectorListener.setFriendListener(this.hostListener);
                this.hostListener.start();
                this.redirectorListener.start();
            }
            catch (Exception e) {
                System.out.println("Exiting redirector main loop: " + e.getMessage());
            }
        }
        System.out.println("Stoping the redirection from " + this.localPort + "  to the port: " + this.redirectPort);
    }
}

