/*
 * Decompiled with CFR 0.152.
 */
package org.raydelto.redirector.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PortListener
extends Thread {
    private InputStream reader;
    private OutputStream writer;
    private Socket socket;
    private boolean destroyed = false;
    private PortListener friendListener;

    public PortListener getFriendListener() {
        return this.friendListener;
    }

    public void setFriendListener(PortListener friendListener) {
        this.friendListener = friendListener;
    }

    public PortListener(InputStream reader, OutputStream writer, Socket socket) {
        System.out.println("Creating port listener");
        this.reader = reader;
        this.writer = writer;
        this.socket = socket;
    }

    public void destroy() {
        if (!this.destroyed) {
            try {
                this.reader.close();
                this.writer.close();
                this.socket.close();
                this.destroyed = true;
            }
            catch (IOException e) {
                System.out.println("Error while finalizing connection");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        int read = 0;
        int nothingToRead = 0;
        while (!this.destroyed) {
            try {
                read = this.reader.read();
                if (read != -1) {
                    this.writer.write(read);
                    continue;
                }
                if (++nothingToRead <= 10) continue;
                this.destroyed = true;
            }
            catch (Exception e) {
                System.out.println("Connection ended:" + e.getMessage());
                this.destroy();
                this.friendListener.destroy();
                System.gc();
            }
        }
        System.out.println("exiting reading loop");
    }
}

