/*
 * Decompiled with CFR 0.152.
 */
package org.raydelto.redirector.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.raydelto.redirector.gui.NumericKeyListener;
import org.raydelto.redirector.net.PortRedirector;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JLabel lblLocalPort;
    private JLabel lblRedirectPort;
    private JTextField txtLocalPort;
    private JTextField txtRedirectPort;
    private JButton btnRedirect;
    private boolean redirecting;
    private PortRedirector pr;

    public MainWindow() {
        super("Port Redirector v1.0 by Raydelto");
        this.setSize(600, 75);
        this.setResizable(false);
        this.setLayout(new FlowLayout());
        this.lblLocalPort = new JLabel("Local Port");
        this.lblRedirectPort = new JLabel("Redirect to Port");
        this.txtLocalPort = new JTextField(10);
        this.txtLocalPort.setPreferredSize(new Dimension(60, 20));
        this.txtRedirectPort = new JTextField(10);
        this.txtRedirectPort.setPreferredSize(new Dimension(60, 20));
        this.txtRedirectPort.setSize(200, 10);
        this.btnRedirect = new JButton("Redirect");
        this.btnRedirect.setBackground(Color.gray);
        this.setDefaultCloseOperation(3);
        NumericKeyListener numericListener = new NumericKeyListener();
        this.txtLocalPort.addKeyListener(numericListener);
        this.txtRedirectPort.addKeyListener(numericListener);
        this.btnRedirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!MainWindow.this.redirecting) {
                    MainWindow.this.pr = new PortRedirector(Integer.parseInt(MainWindow.this.txtLocalPort.getText()), Integer.parseInt(MainWindow.this.txtRedirectPort.getText()));
                    MainWindow.this.redirecting = true;
                    MainWindow.this.btnRedirect.setText("redirecting");
                    MainWindow.this.btnRedirect.setBackground(Color.green);
                    MainWindow.this.txtLocalPort.setEditable(false);
                    MainWindow.this.txtRedirectPort.setEditable(false);
                    MainWindow.this.pr.start();
                    MainWindow.this.setTitle("Port Redirector v1.0 by Raydelto: Redirecting port " + MainWindow.this.txtLocalPort.getText() + " to " + MainWindow.this.txtRedirectPort.getText());
                } else if (JOptionPane.showConfirmDialog(MainWindow.this, "Do you confirm you want to stop redirecting?") == 0) {
                    MainWindow.this.redirecting = false;
                    MainWindow.this.pr.setDisabled(true);
                    MainWindow.this.btnRedirect.setBackground(Color.gray);
                    MainWindow.this.btnRedirect.setText("Redirect");
                    MainWindow.this.txtLocalPort.setEditable(true);
                    MainWindow.this.txtRedirectPort.setEditable(true);
                    MainWindow.this.setTitle("Port Redirector v1.0 by Raydelto");
                }
            }
        });
        this.add(this.lblLocalPort);
        this.add(this.txtLocalPort);
        this.add(this.lblRedirectPort);
        this.add(this.txtRedirectPort);
        this.add(this.btnRedirect);
        this.setVisible(true);
    }
}

